implementation module StdControlReceiver


import	StdTuple
import	commondef, id, receiveraccess, receiverdefaccess, StdReceiverDef, StdControlClass, windowhandle
from	oswindow	import OSNoWindowPtr


instance Controls (Receiver m)
where
	controlToHandles :: !(Receiver m .ls (PSt .l .p)) -> [ControlState .ls (PSt .l .p)]
	controlToHandles (Receiver rid f atts)
		= [WElementHandleToControlState
			(WItemHandle 
			{	wItemId			= Just id
			,	wItemNr			= 0
			,	wItemKind		= IsOtherControl "Receiver"
			,	wItemShow		= False
			,	wItemSelect		= enabled select
			,	wItemInfo		= ReceiverInfo (newReceiverHandle id select f)
			,	wItemAtts		= []
			,	wItems			= []
			,	wItemPos		= zero
			,	wItemFixedPos	= False
			,	wItemSize		= zero
			,	wItemPtr		= OSNoWindowPtr
			})]
	where
		id		= RIdtoId rid
		select	= getSelectState atts
	
	getControlType :: (Receiver m .ls .ps) -> ControlType
	getControlType _
		= "Receiver"
instance Controls (Receiver2 m r)
where
	controlToHandles :: !(Receiver2 m r .ls (PSt .l .p)) -> [ControlState .ls (PSt .l .p)]
	controlToHandles (Receiver2 r2id f atts)
		= [WElementHandleToControlState
			(WItemHandle 
			{	wItemId			= Just id
			,	wItemNr			= 0
			,	wItemKind		= IsOtherControl "Receiver2"
			,	wItemShow		= False
			,	wItemSelect		= enabled select
			,	wItemInfo		= ReceiverInfo (newReceiverHandle2 id select f)
			,	wItemAtts		= []
			,	wItems			= []
			,	wItemPos		= zero
			,	wItemFixedPos	= False
			,	wItemSize		= zero
			,	wItemPtr		= OSNoWindowPtr
			})]
	where
		id		= R2IdtoId r2id
		select	= getSelectState atts
	
	getControlType :: (Receiver2 m r .ls .ps) -> ControlType
	getControlType _
		= "Receiver2"

getSelectState :: ![ReceiverAttribute .ps] -> SelectState
getSelectState rAtts
	= getreceiverselectstate (snd (Select isreceiverselectstate (ReceiverSelectState Able) rAtts))
